const express = require('express');
const controllerSubs = require('../controllers/subs');
const router = express.Router();

router.post('/subs', controllerSubs.addSubs);

router.get('/subs', controllerSubs.subsChunk);

router.get('/sub/:_id', controllerSubs.viewSub);

//router.get('/sub-verified/:_id', controllerSubs.verifySub);

router.get('/sub-verified', controllerSubs.verifySub);

router.post('/delete-sub', controllerSubs.postDeleteSub);

router.post('/rename-sub', controllerSubs.postRenameSub);

router.get('/emails-api', controllerSubs.getSubsAPI);

router.post('/post-email-api', controllerSubs.postSubAPI);

router.get('/', controllerSubs.renderIndex);

module.exports = router;