const express = require('express');
const authSubs = require('../controllers/auth');
const router = express.Router();

router.get('/login', authSubs.getLogin);
router.get('/signup', authSubs.getSignup);
router.post('/login', authSubs.postLogin);
router.post('/logout', authSubs.postLogout);
router.post('/signup', authSubs.postSignup);

module.exports = router;