const bcrypt = require('bcryptjs');
const User = require('../models/user');

exports.getLogin = (req, res, next) => {
    console.log('req.session: ', req.session);
    res.render('auth/login', {
        pageHead: 'Login',
        pageTitle: 'Login Page',
        pageIntro: 'This is the login page.',
        path: '/login',
        isLoggedIn: req.session.isLoggedIn //req.get('Cookie') == undefined ? false : req.get('Cookie').split('=')[1]
    });
    console.log('cookie: ', req.get('Cookie')); // test
}

exports.postLogin = (req, res, next) => {
    //req.isLoggedIn = true;
    //res.setHeader('Set-Cookie', 'loggedIn=true'); // sets cookie
    req.session.isLoggedIn = true;
    res.redirect('/');
}

exports.postLogout = (req, res, next) => {
    req.session.destroy((err) => {
        console.log(err);
        res.redirect('/'); // or change to 'logged out' page
    });
}

exports.getSignup = (req, res, next) => {
    res.render('auth/signup', {
        pageHead: 'Sign Up',
        pageTitle: 'Sign Up',
        pageIntro: 'This is the sign-up page.',
        path: '/signup',
        isLoggedIn: req.session.isLoggedIn //req.get('Cookie') == undefined ? false : req.get('Cookie').split('=')[1]
    });
}

exports.postSignup = (req, res, next) => {
    const email = req.body.email;
    const password = req.body.password;
    //const confirmPassword = req.body.confirmPassword; // may be incorrect
    console.log('email: ', email, 'password: ', password);
    User.findByEm(email)
        .then(user => {
            console.log('Another user test: ', user);
            if (user !== null) {
                console.log('entry already found - should not add');
                res.render('auth/signup', {
                    pageHead: 'Sign Up',
                    pageTitle: 'ERROR: email already registered',
                    pageIntro: 'ERROR: email already registered. Please enter a unique email address.',
                    path: '/signup',
                    isLoggedIn: req.session.isLoggedIn //req.get('Cookie') == undefined ? false : req.get('Cookie').split('=')[1]
                });
                return Promise.reject(err);
            }
            console.log('test', 'bcrypt.hash(password, 12): ', bcrypt.hash(password, 12));
            return bcrypt.hash(password, 12);
        })
        .then(hashedPassword => {
            console.log('hashedPassword: ', hashedPassword);
            const user = new User(email, hashedPassword);
            console.log('user: ', user);
            return user.save()
        })
        .then(result => {
            res.render('auth/signup', {
                pageHead: 'Sign Up',
                pageTitle: 'SUCCESS: new entry added',
                pageIntro: 'New entry added successfully',
                path: '/signup',
                isLoggedIn: req.session.isLoggedIn //req.get('Cookie') == undefined ? false : req.get('Cookie').split('=')[1]
            });
        })
        .catch(err => {
            console.log(err);
        });
}